<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateClientsTable extends Migration {

	public function up()
	{
		Schema::create('clients', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->string('Name', 255);
			$table->string('Email', 255)->unique();
			$table->date('Date_of_birth');
			$table->date('last_date_of_donation')->nullable();
			$table->integer('City_id')->unsigned()->index();
			$table->integer('Phone_number')->unique()->unsigned();
			$table->string('password', 255);
			$table->string('api_token', 255);
		});
	}

	public function down()
	{
		Schema::drop('clients');
	}
}