<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class User extends Model 
{

    protected $table = 'users';
    public $timestamps = true;

    public function purchases()
    {
        return $this->hasMany('Purchase');
    }

    public function tests()
    {
        return $this->hasMany('Test');
    }

    public function country()
    {
        return $this->belongsTo('Country');
    }

    public function deparment()
    {
        return $this->belongsTo('Department');
    }

    public function municipality()
    {
        return $this->belongsTo('Municipality');
    }

}