<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCampagnesTable extends Migration {

	public function up()
	{
		Schema::create('campagnes', function(Blueprint $table) {
			$table->increments('id');
			$table->string('type', 20);
			$table->string('libelle', 100);
			$table->date('date_debut');
			$table->date('date_fin');
			$table->string('identifiant', 9)->unique();
			$table->tinyInteger('actif')->default('0');
			$table->string('annee_univ', 4)->unique();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('campagnes');
	}
}