<?php

namespace App\Models\Reference;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Finish extends Eloquent {

	protected $table = 'finishes';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];

	public function services()
	{
		return $this->belongsToMany('Service', 'service_finish', 'finish_id', 'service_id')->withTimestamps();
	}

	public function materials()
	{
		return $this->belongsToMany('MaterialType', 'material_finish', 'finish_id', 'material_type_id')->withTimestamps();
	}

	public function finishTypes()
	{
		return $this->belongsToMany('FinishType', 'finish_type_finish', 'finish_id', 'finish_type_id')->withTimestamps();
	}

	public function secondaryPairings()
	{
		return $this->belongsToMany('Finish', 'primary_finish_secondary_finish', 'primary_finish_id', 'secondary_finish_id')->withTimestamps();
	}

	public function primaryPairings()
	{
		return $this->belongsToMany('Finish', 'primary_finish_secondary_finish', 'secondary_finish_id', 'primary_finish_id')->withTimestamps();
	}

}