<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCompaniesTable extends Migration {

	public function up()
	{
		Schema::create('companies', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 200);
			$table->integer('admin_id')->unsigned();
			$table->text('website')->nullable();
			$table->string('logo', 255)->nullable();
			$table->string('description', 255);
			$table->string('location', 200);
			$table->string('size', 255)->nullable();
			$table->string('hired_people', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('companies');
	}
}