<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExperiencesTable extends Migration {

	public function up()
	{
		Schema::create('experiences', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('profile_id');
			$table->string('company', 200);
			$table->string('position', 200);
			$table->date('start_date');
			$table->date('end_date')->nullable();
			$table->tinyInteger('is_current')->default('0');
			$table->string('description', 255)->nullable();
			$table->string('location', 200);
			$table->string('image', 255)->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('experiences');
	}
}