<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrganizationsTable extends Migration {

	public function up()
	{
		Schema::create('organizations', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name');
			$table->string('logo_url');
			$table->string('image_url');
			$table->string('home_page');
			$table->string('telephone', 50);
			$table->string('email');
			$table->integer('status')->default('1');
			$table->string('contact');
			$table->integer('province_id');
			$table->integer('city_id');
			$table->integer('region_id');
			$table->string('address');
			$table->string('zipcode');
			$table->string('longitude');
			$table->string('latitude');
			$table->string('mark');
			$table->datetime('created_at');
			$table->datetime('updated_at');
		});
	}

	public function down()
	{
		Schema::drop('organizations');
	}
}