<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCoursesTable extends Migration {

	public function up()
	{
		Schema::create('courses', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('org_id')->unsigned();
			$table->string('logo_url');
			$table->string('image_url');
			$table->string('contact');
			$table->string('telephone');
			$table->integer('province_id');
			$table->string('subject');
			$table->integer('city_id');
			$table->integer('region_id');
			$table->string('address');
			$table->string('zipcode');
			$table->string('longitude');
			$table->string('latitude');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->string('mark');
			$table->integer('status');
		});
	}

	public function down()
	{
		Schema::drop('courses');
	}
}