<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminUsersTable extends Migration {

	public function up()
	{
		Schema::create('admin_users', function(Blueprint $table) {
			$table->increments('id');
			$table->string('name', 255);
			$table->string('password', 255);
			$table->string('email', 255);
			$table->string('session_token');
			$table->integer('status')->default('1');
			$table->datetime('login_at');
			$table->datetime('created_at');
			$table->datetime('updated_at');
			$table->string('mark', 1024);
			$table->integer('role_id')->unsigned();
		});
	}

	public function down()
	{
		Schema::drop('admin_users');
	}
}