<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class Invoice extends Eloquent {

	protected $table = 'invoice';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('subscription_id', 'price', 'status');

	public function subscription()
	{
		return $this->belongsTo('Subscription', 'subscription_id');
	}

	public function histories()
	{
		return $this->hasMany('InvoiceHistory', 'invoice_id');
	}

}