<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSubscriptionTable extends Migration {

	public function up()
	{
		Schema::create('subscription', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('client_id')->nullable();
			$table->integer('tower_id')->nullable();
			$table->integer('package_id')->nullable();
			$table->double('first_invoice')->nullable();
			$table->enum('status', array('active', 'inactive'))->nullable();
			$table->integer('user_id')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('subscription');
	}
}