<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreatePauseRequestTable extends Migration {

	public function up()
	{
		Schema::create('pause_request', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->integer('subscription_id')->nullable();
			$table->integer('user_id')->nullable();
			$table->text('note')->nullable();
			$table->enum('status', array(''))->nullable();
		});
	}

	public function down()
	{
		Schema::drop('pause_request');
	}
}