<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateRiskAlertsTable extends Migration {

	public function up()
	{
		Schema::create('risk_alerts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->bigInteger('risk_setting_id')->unsigned()->nullable();
			$table->bigInteger('jack_customer_id')->unsigned()->nullable();
			$table->enum('action', array('sendalert', 'blockclient', 'noaction'))->nullable();
			$table->longText('reasons')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('risk_alerts');
	}
}