<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalInvestigationsTable extends Migration {

	public function up()
	{
		Schema::create('legal_investigations', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('investigation_number', 100)->nullable();
			$table->date('investigation_date')->nullable();
			$table->bigInteger('employee_judge')->unsigned()->nullable();
			$table->bigInteger('employee_accused')->unsigned()->nullable();
			$table->string('subject', 100)->nullable();
			$table->longText('reason')->nullable();
			$table->enum('result_status', array('recommensation', 'penalty'))->nullable();
			$table->longText('result_note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('legal_investigations');
	}
}