<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSystemAccountsTable extends Migration {

	public function up()
	{
		Schema::create('system_accounts', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('reference_number', 100)->nullable();
			$table->string('name', 100)->nullable();
			$table->boolean('status')->nullable();
			$table->enum('account_type', array('main', 'secondry'))->nullable();
			$table->string('symbole', 100);
			$table->integer('parent_id')->unsigned()->nullable();
			$table->integer('payment_check')->nullable();
			$table->boolean('collect_check')->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('system_accounts');
	}
}