<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateNotificationsTable extends Migration {

	public function up()
	{
		Schema::create('notifications', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('notification_number')->nullable();
			$table->double('amount')->nullable();
			$table->integer('employee_id')->nullable();
			$table->string('complain_number')->nullable();
			$table->enum('notification_type', array('adding', 'equation', 'discount'))->nullable();
			$table->enum('dealing', array('Customer', 'ServiceProvider'))->nullable();
			$table->integer('notification_name_id')->unsigned()->nullable();
			$table->integer('management_id')->nullable();
			$table->json('attachments')->nullable();
			$table->integer('source_customer_id')->unsigned()->nullable();
			$table->integer('destination_customer_id')->unsigned()->nullable();
			$table->integer('source_bank_id')->unsigned()->nullable();
			$table->integer('destination_bank_id')->unsigned()->nullable();
			$table->string('source_iban', 100)->nullable();
			$table->string('destination_iban')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('notifications');
	}
}