<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLegalRegionsTable extends Migration {

	public function up()
	{
		Schema::create('legal_regions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name', 100)->nullable();
			$table->boolean('status')->nullable();
			$table->bigInteger('country_id')->unsigned()->nullable();
		});
	}

	public function down()
	{
		Schema::drop('legal_regions');
	}
}