<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateFiCustodiesTable extends Migration {

	public function up()
	{
		Schema::create('fi_custodies', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('invoice_number', 100)->unique()->nullable();
			$table->string('tax_number', 100)->nullable();
			$table->string('supplier_name', 100)->nullable();
			$table->double('total_amount')->nullable();
			$table->double('invoice_tax_value')->nullable();
			$table->double('net_amount')->nullable();
			$table->date('date')->nullable();
			$table->integer('managment_id')->nullable();
			$table->integer('expense_type_id')->unsigned()->nullable();
			$table->json('attatchments')->nullable();
			$table->integer('cost_center_id')->nullable();
			$table->string('supply_employee_name', 150)->nullable();
			$table->text('note')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('fi_custodies');
	}
}