<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAccountingRestrictionsTable extends Migration {

	public function up()
	{
		Schema::create('accounting_restrictions', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('restriction_number', 100)->nullable();
			$table->integer('employee_id')->nullable();
			$table->integer('customer_id')->unsigned()->nullable();
			$table->integer('restriction_type')->unsigned()->nullable();
			$table->string('document_number', 100)->nullable();
			$table->longText('description')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('accounting_restrictions');
	}
}