<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTestsTable extends Migration {

	public function up()
	{
		Schema::create('tests', function(Blueprint $table) {
			$table->increments('id');
			$table->string('test_name');
			$table->text('instructions')->nullable();
			$table->text('description')->nullable();
			$table->text('notes')->nullable();
			$table->integer('total_questions')->default('0');
			$table->integer('typetest_id')->unsigned();
			$table->timestamps();
			$table->integer('order')->unsigned()->default('1');
			$table->tinyInteger('is_evaluation')->default('0');
			$table->mediumInteger('algorithm')->default('0');
			$table->tinyInteger('coach_assistance')->default('0');
			$table->tinyInteger('active')->default('1');
			$table->string('video_url')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('tests');
	}
}