<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateResultsTable extends Migration {

	public function up()
	{
		Schema::create('results', function(Blueprint $table) {
			$table->increments('id');
			$table->float('total')->nullable();
			$table->text('explanation')->nullable();
			$table->text('graphic_img')->nullable();
			$table->text('answers')->nullable();
			$table->text('coach_retro')->nullable();
			$table->integer('test_id')->unsigned();
			$table->integer('user_id')->unsigned();
			$table->integer('typeresult_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('results');
	}
}