<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLessonsTable extends Migration {

	public function up()
	{
		Schema::create('lessons', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lesson_name');
			$table->integer('number')->default('1');
			$table->integer('no_videos')->default('0');
			$table->integer('no_exercises')->default('0');
			$table->string('image_icon')->nullable();
			$table->tinyInteger('active')->default('1');
			$table->string('pdf_file')->nullable();
			$table->integer('module_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('lessons');
	}
}