<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOptionsTable extends Migration {

	public function up()
	{
		Schema::create('options', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('number')->default('0');
			$table->text('option');
			$table->tinyInteger('correct')->nullable()->default('0');
			$table->integer('value')->nullable();
			$table->text('explanation')->nullable();
			$table->integer('question_id')->unsigned();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('options');
	}
}