<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateModulesTable extends Migration {

	public function up()
	{
		Schema::create('modules', function(Blueprint $table) {
			$table->increments('id');
			$table->string('module_name');
			$table->integer('no_lessons')->nullable();
			$table->string('image_icon');
			$table->tinyInteger('active')->default('1');
			$table->text('description')->nullable();
			$table->string('meta_keywords')->nullable();
			$table->string('meta_description')->nullable();
			$table->string('plan')->nullable();
			$table->mediumInteger('order')->default('0');
			$table->integer('course_id')->unsigned()->nullable();
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('modules');
	}
}