<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('scooter', function(Blueprint $table) {
			$table->foreign('id_range_base_price')->references('id')->on('range_base_price')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('scooter', function(Blueprint $table) {
			$table->foreign('id_autonomy')->references('id')->on('autonomy')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('scooter_contract', function(Blueprint $table) {
			$table->foreign('id_scooter')->references('id')->on('scooter')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
		Schema::table('scooter_contract', function(Blueprint $table) {
			$table->foreign('id_contract_duration')->references('id')->on('contract_duration')
						->onDelete('cascade')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('scooter', function(Blueprint $table) {
			$table->dropForeign('scooter_id_range_base_price_foreign');
		});
		Schema::table('scooter', function(Blueprint $table) {
			$table->dropForeign('scooter_id_autonomy_foreign');
		});
		Schema::table('scooter_contract', function(Blueprint $table) {
			$table->dropForeign('scooter_contract_id_scooter_foreign');
		});
		Schema::table('scooter_contract', function(Blueprint $table) {
			$table->dropForeign('scooter_contract_id_contract_duration_foreign');
		});
	}
}