<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateOrderItemTable extends Migration {

	public function up()
	{
		Schema::create('OrderItem', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->decimal('amount_refunded');
			$table->decimal('base_amount_refunded');
			$table->decimal('base_discount_amount');
			$table->decimal('base_discount_invoiced');
			$table->decimal('base_discount_tax_compensation_amount');
			$table->decimal('base_original_price');
			$table->decimal('base_price');
			$table->decimal('base_price_incl_tax');
			$table->decimal('base_row_invoiced');
			$table->decimal('base_row_total');
			$table->decimal('base_row_total_incl_tax');
			$table->decimal('base_tax_amount');
			$table->decimal('base_tax_invoiced');
			$table->decimal('discount_amount');
			$table->decimal('discount_invoiced');
			$table->decimal('discount_percent');
			$table->decimal('discount_tax_compensation_amount');
			$table->string('name');
			$table->decimal('original_price');
			$table->decimal('price');
			$table->decimal('price_incl_tax');
			$table->integer('product_id');
			$table->string('product_type');
			$table->decimal('qty_canceled');
			$table->decimal('qty_invoiced');
			$table->decimal('qty_ordered');
			$table->decimal('qty_refunded');
			$table->decimal('qty_shipped');
			$table->decimal('row_invoiced');
			$table->decimal('row_total');
			$table->decimal('row_total_incl_tax');
			$table->decimal('row_weight');
			$table->string('sku');
			$table->decimal('tax_amount');
			$table->decimal('tax_invoiced');
			$table->decimal('tax_percent');
			$table->decimal('weight');
		});
	}

	public function down()
	{
		Schema::drop('OrderItem');
	}
}