<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExpertPackageReservationItemsTable extends Migration {

	public function up()
	{
		Schema::create('expert_package_reservation_items', function(Blueprint $table) {
			$table->increments('id');
			$table->integer('expert_package_reservation_id')->unsigned();
			$table->integer('package_item_id');
			$table->integer('service_id')->unsigned();
			$table->integer('session_order')->default('1');
			$table->enum('session_type', array('duration', 'manual'));
			$table->datetime('start_time')->nullable();
			$table->datetime('end_time')->nullable();
			$table->enum('status', array('wait', 'process', 'done', 'canceled'));
			$table->timestamps();
		});
	}

	public function down()
	{
		Schema::drop('expert_package_reservation_items');
	}
}