<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Article extends Model 
{

    protected $table = 'articles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('hashtags', 'title', 'description');
    protected $visible = array('hashtags', 'title', 'description');

    public function post()
    {
        return $this->belongsTo('Post', 'id', 'post_id');
    }

}