<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateDoctorsTable extends Migration {

	public function up()
	{
		Schema::create('doctors', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lang', 255)->nullable();
			$table->string('name', 255);
			$table->string('phone', 255)->unique();
			$table->string('email', 255)->unique();
			$table->string('password', 255);
			$table->tinyInteger('trem')->default('0');
			$table->enum('status', array('0', '1', '2'));
			$table->string('latitude', 255);
			$table->string('longitude', 255);
			$table->text('location');
			$table->bigInteger('fb_id');
			$table->bigInteger('google_id');
			$table->bigInteger('apple_id');
			$table->integer('pin_code')->unsigned();
			$table->text('about')->nullable();
			$table->string('full_perfessional_title', 255)->nullable();
			$table->date('d_o_b');
			$table->softDeletes();
			$table->timestamps();
			$table->integer('year_experience')->nullable();
			$table->bigInteger('viewers');
		});
	}

	public function down()
	{
		Schema::drop('doctors');
	}
}