<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreSpecialty extends Eloquent {

	protected $table = 'store_specialty';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'specialty_id');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function specialty()
	{
		return $this->belongsTo('Specialty', 'specialty_id');
	}

}