<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class StoreOrder extends Eloquent {

	protected $table = 'store_order';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('store_id', 'order_id', 'status');

	public function store()
	{
		return $this->belongsTo('Store', 'store_id');
	}

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

}