<?php

namespace Api;

use Illuminate\Database\Eloquent\SoftDeletingTrait;

class OrderSpecialty extends Eloquent {

	protected $table = 'order_specialty';
	public $timestamps = true;

	use SoftDeletingTrait;

	protected $dates = ['deleted_at'];
	protected $fillable = array('order_id', 'specialty_id');

	public function order()
	{
		return $this->belongsTo('Order', 'order_id');
	}

	public function specialty()
	{
		return $this->belongsTo('Specialty', 'specialty_id');
	}

}