<?php

namespace role;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Role extends Model 
{

    protected $table = 'roles';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];

    public function admin_roles()
    {
        return $this->hasOne('AdminUser', 'role_id');
    }

    public function role_permission_relation()
    {
        return $this->hasMany('RolePermission', 'role_id');
    }

}