<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCouponsTable extends Migration {

	public function up()
	{
		Schema::create('coupons', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->string('name');
			$table->enum('discount_type', array(''fixed'', ''percent''));
			$table->text('layers');
			$table->datetime('start_at')->nullable();
			$table->datetime('end_at')->nullable();
			$table->integer('uses');
			$table->integer('max_uses')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('coupons');
	}
}