<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('governates', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->foreign('brand_id')->references('id')->on('brands')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('supplier_orders', function(Blueprint $table) {
			$table->foreign('supplier_id')->references('id')->on('suppliers')
						->onDelete('cascade')
						->onUpdate('no action');
		});
		Schema::table('supplier_order_items', function(Blueprint $table) {
			$table->foreign('supplier_order_id')->references('id')->on('supplier_orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('supplier_order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('gouvernment_id')->references('id')->on('governates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->foreign('gouvernment_id')->references('id')->on('governates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('users')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('country_id')->references('id')->on('country')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('gouvernment_id')->references('id')->on('governates')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->foreign('category_id')->references('id')->on('categories')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('shipping_id')->references('id')->on('shippings')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->foreign('page_id')->references('id')->on('pages')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('cascade')
						->onUpdate('restrict');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('return_orders', function(Blueprint $table) {
			$table->foreign('order_id')->references('id')->on('orders')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('return_orders', function(Blueprint $table) {
			$table->foreign('product_id')->references('id')->on('products')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('brands', function(Blueprint $table) {
			$table->dropForeign('brands_category_id_foreign');
		});
		Schema::table('governates', function(Blueprint $table) {
			$table->dropForeign('governates_country_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_category_id_foreign');
		});
		Schema::table('products', function(Blueprint $table) {
			$table->dropForeign('products_brand_id_foreign');
		});
		Schema::table('supplier_orders', function(Blueprint $table) {
			$table->dropForeign('supplier_orders_supplier_id_foreign');
		});
		Schema::table('supplier_order_items', function(Blueprint $table) {
			$table->dropForeign('supplier_order_items_supplier_order_id_foreign');
		});
		Schema::table('supplier_order_items', function(Blueprint $table) {
			$table->dropForeign('supplier_order_items_product_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_gouvernment_id_foreign');
		});
		Schema::table('users', function(Blueprint $table) {
			$table->dropForeign('users_country_id_foreign');
		});
		Schema::table('cities', function(Blueprint $table) {
			$table->dropForeign('cities_gouvernment_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_page_id_foreign');
		});
		Schema::table('pages', function(Blueprint $table) {
			$table->dropForeign('pages_user_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_country_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_gouvernment_id_foreign');
		});
		Schema::table('shippings', function(Blueprint $table) {
			$table->dropForeign('shippings_city_id_foreign');
		});
		Schema::table('warehouses', function(Blueprint $table) {
			$table->dropForeign('warehouses_category_id_foreign');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->dropForeign('deprecation_orders_order_id_foreign');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->dropForeign('deprecation_orders_product_id_foreign');
		});
		Schema::table('deprecation_orders', function(Blueprint $table) {
			$table->dropForeign('deprecation_orders_category_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_shipping_id_foreign');
		});
		Schema::table('orders', function(Blueprint $table) {
			$table->dropForeign('orders_page_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_order_id_foreign');
		});
		Schema::table('order_items', function(Blueprint $table) {
			$table->dropForeign('order_items_product_id_foreign');
		});
		Schema::table('return_orders', function(Blueprint $table) {
			$table->dropForeign('return_orders_order_id_foreign');
		});
		Schema::table('return_orders', function(Blueprint $table) {
			$table->dropForeign('return_orders_product_id_foreign');
		});
	}
}