<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->timestamps();
			$table->softDeletes();
			$table->longText('name');
			$table->string('email', 255)->unique();
			$table->string('phone', 20)->nullable();
			$table->string('password');
			$table->tinyInteger('type')->default('0');
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}