<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('produit', function(Blueprint $table) {
			$table->foreign('categorieproduitfao_id')->references('id')->on('categorieproduitfao')
						->onDelete('no action')
						->onUpdate('set null');
		});
		Schema::table('produit', function(Blueprint $table) {
			$table->foreign('typeproduit_id')->references('id')->on('typeproduit')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->foreign('agent_id')->references('id')->on('agent')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->foreign('usager_id')->references('id')->on('usager')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->foreign('mesureprescrite_id')->references('id')->on('mesureprescrite')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->foreign('pays_id')->references('id')->on('pays')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->foreign('fournisseurimportateur_id')->references('id')->on('fournisseurimportateur')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->foreign('organismequarantaine_id')->references('id')->on('organismequarantaine')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->foreign('produit_id')->references('id')->on('produit')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->foreign('permisimportation_id')->references('id')->on('typeproduit')
						->onDelete('no action')
						->onUpdate('cascade');
		});
		Schema::table('usager', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('agent', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->foreign('moyentransport_id')->references('id')->on('moyentransport')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->foreign('pointentree_id')->references('id')->on('pointentree')
						->onDelete('restrict')
						->onUpdate('no action');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->foreign('pays_id')->references('id')->on('pays')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->foreign('permisimportation_id')->references('id')->on('permisimportation')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->foreign('user_id')->references('id')->on('user')
						->onDelete('restrict')
						->onUpdate('cascade');
		});
	}

	public function down()
	{
		Schema::table('produit', function(Blueprint $table) {
			$table->dropForeign('produit_categorieproduitfao_id_foreign');
		});
		Schema::table('produit', function(Blueprint $table) {
			$table->dropForeign('produit_typeproduit_id_foreign');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->dropForeign('permisimportation_agent_id_foreign');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->dropForeign('permisimportation_usager_id_foreign');
		});
		Schema::table('permisimportation', function(Blueprint $table) {
			$table->dropForeign('permisimportation_mesureprescrite_id_foreign');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->dropForeign('produitofpermis_pays_id_foreign');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->dropForeign('produitofpermis_fournisseurimportateur_id_foreign');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->dropForeign('produitofpermis_organismequarantaine_id_foreign');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->dropForeign('produitofpermis_produit_id_foreign');
		});
		Schema::table('produitofpermis', function(Blueprint $table) {
			$table->dropForeign('produitofpermis_permisimportation_id_foreign');
		});
		Schema::table('usager', function(Blueprint $table) {
			$table->dropForeign('usager_user_id_foreign');
		});
		Schema::table('agent', function(Blueprint $table) {
			$table->dropForeign('agent_user_id_foreign');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->dropForeign('importation_moyentransport_id_foreign');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->dropForeign('importation_pointentree_id_foreign');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->dropForeign('importation_pays_id_foreign');
		});
		Schema::table('importation', function(Blueprint $table) {
			$table->dropForeign('importation_permisimportation_id_foreign');
		});
		Schema::table('logs', function(Blueprint $table) {
			$table->dropForeign('logs_user_id_foreign');
		});
	}
}