<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateForeignKeys extends Migration {

	public function up()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('city_id')->references('id')->on('cities')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->foreign('clinic_id')->references('clinic_id')->on('clinics')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->foreign('sub_service')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('sub_services', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->foreign('chat_id')->references('id')->on('chats')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->foreign('admin_id')->references('id')->on('admins')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('branch_id')->references('id')->on('branches')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('offer_id')->references('id')->on('offers')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('service_id')->references('id')->on('services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->foreign('sub_service_id')->references('id')->on('sub_services')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patient_notifications', function(Blueprint $table) {
			$table->foreign('patient_id')->references('id')->on('patients')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
		Schema::table('patient_notifications', function(Blueprint $table) {
			$table->foreign('notification_id')->references('id')->on('notifications')
						->onDelete('restrict')
						->onUpdate('restrict');
		});
	}

	public function down()
	{
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_city_id_foreign');
		});
		Schema::table('branches', function(Blueprint $table) {
			$table->dropForeign('branches_clinic_id_foreign');
		});
		Schema::table('facilities', function(Blueprint $table) {
			$table->dropForeign('facilities_branch_id_foreign');
		});
		Schema::table('offers', function(Blueprint $table) {
			$table->dropForeign('offers_branch_id_foreign');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->dropForeign('offer_items_offer_id_foreign');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->dropForeign('offer_items_service_id_foreign');
		});
		Schema::table('offer_items', function(Blueprint $table) {
			$table->dropForeign('offer_items_sub_service_foreign');
		});
		Schema::table('services', function(Blueprint $table) {
			$table->dropForeign('services_branch_id_foreign');
		});
		Schema::table('sub_services', function(Blueprint $table) {
			$table->dropForeign('sub_services_service_id_foreign');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->dropForeign('branch_service_branch_id_foreign');
		});
		Schema::table('branch_service', function(Blueprint $table) {
			$table->dropForeign('branch_service_service_id_foreign');
		});
		Schema::table('prescriptions', function(Blueprint $table) {
			$table->dropForeign('prescriptions_patient_id_foreign');
		});
		Schema::table('notifications', function(Blueprint $table) {
			$table->dropForeign('notifications_patient_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_patient_id_foreign');
		});
		Schema::table('chats', function(Blueprint $table) {
			$table->dropForeign('chats_admin_id_foreign');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->dropForeign('chat_message_chat_id_foreign');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->dropForeign('chat_message_patient_id_foreign');
		});
		Schema::table('chat_message', function(Blueprint $table) {
			$table->dropForeign('chat_message_admin_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_branch_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_patient_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_offer_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_service_id_foreign');
		});
		Schema::table('appointments', function(Blueprint $table) {
			$table->dropForeign('appointments_sub_service_id_foreign');
		});
		Schema::table('patient_notifications', function(Blueprint $table) {
			$table->dropForeign('patient_notifications_patient_id_foreign');
		});
		Schema::table('patient_notifications', function(Blueprint $table) {
			$table->dropForeign('patient_notifications_notification_id_foreign');
		});
	}
}