<?php

namespace App\Models;

class Speciality extends Eloquent {

	protected $table = 'specialities';
	public $timestamps = true;
	protected $fillable = array('name_ar', 'name_en', 'desc_ar', 'desc_en');

	public function photos()
	{
		return $this->morphMany('App\Models\Photo', 'photoable');
	}

	public function blogs()
	{
		return $this->hasMany('App\Models\Blog');
	}

	public function doctors()
	{
		return $this->hasMany('App\Models\Doctor');
	}

	public function clients()
	{
		return $this->hasMany('App\Models\Client');
	}

}