<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateEscrowOfficersTable extends Migration {

	public function up()
	{
		Schema::create('escrow_officers', function(Blueprint $table) {
			$table->uuid('uuid')->primary()->index();
			$table->timestamps();
			$table->softDeletes();
			$table->string('emailAddress')->nullable();
			$table->string('fullName')->nullable();
			$table->timestamp('invoiceSentAt')->nullable();
			$table->timestamp('reminderLastSentAt')->nullable();
		});
	}

	public function down()
	{
		Schema::drop('escrow_officers');
	}
}