<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateUsersTable extends Migration {

	public function up()
	{
		Schema::create('users', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('department_id')->unsigned()->index();
			$table->string('name', 255)->index();
			$table->string('phone', 255)->unique();
			$table->string('email', 255)->unique();
			$table->integer('type');
			$table->string('password', 255);
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('users');
	}
}