<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateTrainingNeedsTable extends Migration {

	public function up()
	{
		Schema::create('training_needs', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned()->nullable()->index();
			$table->bigInteger('department_id')->unsigned()->index();
			$table->integer('status')->nullable()->index();
			$table->timestamp('date_sent');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('training_needs');
	}
}