<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateSectionsTable extends Migration {

	public function up()
	{
		Schema::create('sections', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('parent_id')->unsigned()->index();
			$table->string('name_ar', 255)->unique();
			$table->string('name_en', 255)->unique();
			$table->longText('description_ar');
			$table->longText('description_en');
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('sections');
	}
}