<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateQuestionsTable extends Migration {

	public function up()
	{
		Schema::create('questions', function(Blueprint $table) {
			$table->increments('id');
			$table->string('exam_id', 255)->index();
			$table->integer('question_type');
			$table->longText('question_text')->nullable();
			$table->longText('answer_text')->nullable();
			$table->longText('explanation')->nullable();
			$table->integer('correct_order')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('questions');
	}
}