<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateLectureSchedulesTable extends Migration {

	public function up()
	{
		Schema::create('lecture_schedules', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('mandatory_lecture_id')->unsigned()->nullable()->index();
			$table->timestamp('date')->nullable();
			$table->timestamp('time')->nullable();
			$table->text('location')->nullable();
			$table->timestamp('date_sent')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('lecture_schedules');
	}
}