<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateCooperativeTrainingRequestsTable extends Migration {

	public function up()
	{
		Schema::create('cooperative_training_requests', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('user_id')->unsigned()->nullable()->index();
			$table->bigInteger('cooperative_training_id')->unsigned()->nullable()->index();
			$table->integer('status')->nullable();
			$table->timestamp('start_date')->nullable()->index();
			$table->timestamp('end_date')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('cooperative_training_requests');
	}
}