<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAdminsTable extends Migration {

	public function up()
	{
		Schema::create('admins', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('role_id')->unsigned()->index();
			$table->bigInteger('department_id')->unsigned()->index();
			$table->string('name', 200)->unique();
			$table->string('email', 255)->unique()->nullable();
			$table->string('phone', 200)->unique()->nullable();
			$table->string('password', 255);
			$table->timestamp('birth_date')->index();
			$table->timestamp('join_date')->index();
			$table->longText('address')->nullable();
			$table->double('salary', 8.2)->nullable();
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('admins');
	}
}