<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateMandatoryLecturesTable extends Migration {

	public function up()
	{
		Schema::create('mandatory_lectures', function(Blueprint $table) {
			$table->increments('id');
			$table->string('lecture_name')->nullable();
			$table->bigInteger('user_id')->unsigned()->index();
			$table->integer('training_type')->nullable();
			$table->bigInteger('department_id')->unsigned()->index();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('mandatory_lectures');
	}
}