<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateExamsTable extends Migration {

	public function up()
	{
		Schema::create('exams', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('course_id')->unsigned();
			$table->string('name_ar', 255);
			$table->string('name_en', 255);
			$table->text('instructions')->nullable();
			$table->double('min_passing_grade')->nullable();
			$table->boolean('random_questions')->nullable();
			$table->integer('num_random_questions')->nullable();
			$table->boolean('status');
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('exams');
	}
}