<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;

class CreateAnswersTable extends Migration {

	public function up()
	{
		Schema::create('answers', function(Blueprint $table) {
			$table->increments('id');
			$table->bigInteger('question_id')->unsigned();
			$table->longText('answer_text')->nullable();
			$table->longText('explanation')->nullable();
			$table->boolean('is_correct')->nullable();
			$table->timestamps();
			$table->softDeletes();
		});
	}

	public function down()
	{
		Schema::drop('answers');
	}
}